#========================================================================================
#
# MakeFile - Make rules for Adobe Photoshop 3.0 Developer Toolkit Basic Examples
#
# Written by Dave Wise
#
# Copyright 1994-1997, Adobe Systems Incorporated.
# All Rights Reserved.
#
# Version	1.00	10/20/94	Original version
#
#========================================================================================

#========================================================================================
# Basic symbols
#========================================================================================
ErrorOut		=	"{Worksheet}"
Out				=	::::Plug-ins:Mac:

h				= :::CIncludes:
Util			= :::Util:
PIRIncludes		= :::RIncludes

#========================================================================================
# Utility library stuff
#========================================================================================
# 68K
Libs			=	"{Libraries}"Interface.o 
RFiles			=	"{Rincludes}"Types.r
Utils			=	{Util}DialogUtilities.c.o {Util}PIUtilities.c.o 

# PPC
alllibs			=	{PPCLibraries}StdCRuntime.o 
					{PPCLibraries}StdCLib.xcoff 
					{PPCLibraries}InterfaceLib.xcoff 
					{PPCLibraries}PPCCRuntime.o 
					{PPCLibraries}MathLib.xcoff
librenames		=	-l MathLib.xcoff=MathLib 
					-l StdCLib.xcoff=StdCLib 
					-l InterfaceLib.xcoff=InterfaceLib
PPCUtilsList	=	{Util}DialogUtilities.c.po {Util}PIUtilities.c.po 
PPCUtils		=	{PPCUtilsList} {alllibs}

#========================================================================================
# Options
#========================================================================================
mbgOpts			=	full
symOpts			=	off

linkOpts		=	-w -sym {symOpts}
cOpts			=	-d Macintosh=1 -mbg {mbgOpts} -sym {symOpts} -i {h} -i ::
ppccOpts		=	-align mac68K -appleext on -sym {symOpts} -i {h}
aOpts			=	-sym {symOpts}

#========================================================================================
# Default rules
#========================================================================================
.c.o				.c
	Echo "# `Date -t` ----- Compiling {Default} (68K)"  {ErrorOut}
	C {cOpts} -r -b2 -bigseg -mc68020 
		{DepDir}{Default}.c -o {Targ}  {ErrorOut}

.c.po				.c
	Echo "# `Date -t` ----- Compiling {Default} (PPC)"  {ErrorOut}
	PPCC {ppccOpts} {DepDir}{Default}.c -o {Targ}  {ErrorOut}

.a.o				.a
	Echo "# `Date -t` ----- Assembling {Default} (68K)"  {ErrorOut}
	Asm {aOpts} -i {h} -i {a} -case obj 
		{DepDir}{Default}.a -o {Targ}  {ErrorOut}
	
#========================================================================================
# Overall build
#========================================================================================

BuildMe				"{Out}CryTIFPlugin"

#========================================================================================
# Dump file
#========================================================================================

Headers	=	{h}PIGeneral.h {h}PITypes.h {h}PIAbout.h 
			{h}PIExport.h {h}DialogUtilities.h {h}PIUtilities.h 
			::ExportUtilities.h

{Util}DialogUtilities.c.o  {h}DialogUtilities.h {Util}DialogUtilities.c
{Util}DialogUtilities.c.po  {h}DialogUtilities.h {Util}DialogUtilities.c

{Util}PIUtilities.c.o  {h}PIUtilities.h {Util}DialogUtilities.c
{Util}PIUtilities.c.po  {h}PIUtilities.h {Util}DialogUtilities.c

"CryTIFPlugin.c.po"			::CryTIFPlugin.c {Headers}

"{Out}CryTIFPlugin"			::CryTIFPlugin.c.o CryTIFPluginUIMac.c.o {Utils}
	Echo "# `Date -t` ----- Linking 'CryTIFPlugin' (68K)"  {ErrorOut}
	Link -sg 'Simple Format...' -rt 8BAM=16000 -t 8BAM -c 8BIM -m ENTRYPOINT -o {Targ} {LinkOpts} 
		::CryTIFPlugin.c.o  CryTIFPluginUIMac.c.o {Utils} {Libs}  {ErrorOut}
	Delete -i {Targ}.SYM  {ErrorOut}
	Echo "Delete 'ICNc';" | Rez -a -o {Targ}  {ErrorOut}

"CryTIFPlugin.xcoff"		"CryTIFPlugin.c.po" "CryTIFPluginUIMac.c.po" {PPCUtilsList}
	Echo "# `Date -t` ----- Linking 'CryTIFPlugin' (PPC)"  {ErrorOut}
	PPCLink -mf -main ENTRYPOINT 
		"CryTIFPlugin.c.po" "CryTIFPluginUIMac.c.po" {PPCUtils} -o {Targ}

#"{Out}CryTIFPlugin"			"CryTIFPlugin.xcoff"
#	Echo "# `Date -t` ----- Making 'CryTIFPlugin' PEF (PPC)"  {ErrorOut}
#	MakePEF -b {librenames} "CryTIFPlugin.xcoff" -o {Targ}

"{Out}CryTIFPlugin"			"::CryTIFPlugin.r"
	Echo "# `Date -t` ----- Rezzing 'CryTIFPlugin'"  {ErrorOut}
	Rez -i {PIRIncludes} -d Macintosh=1 -d MSWindows=0 -a -rd {RFiles} "::CryTIFPlugin.r" -o {Targ}  {ErrorOut}

CryTIFPlugin.c.o  ::CryTIFPlugin.c
